
-- Rain parameters
kPPS = 8;               -- Number of particles generated per second
kGravity = 800 ;            -- Gravity in pixels/second/second

-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

function Init()
  SetTexture("sparkle4");
  SetBlendMode(kBlendNormal);
  SetNumParticles(1);
end

floor = math.floor

ParticlesPerSecond = NewParticleGenerator();
StopSpouting = NewTimeout(500);
TestDone = NewTimeout(2000);

function Update(ms)
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

  if (not StopSpouting(ms)) then
  -- InitPosition( "vRange", Vec3(0, 0, 0), Vec3(0, 0, 0) );
  -- InitVelocity( "vRadius", 2)
   InitScale( "fRange", 0.5, 1 );
   InitAge("iRange", 0, 0);
   CreateParticles(newParticles);
  end

   Do("move");
   DoAge("iAge");
   DoColor("cFade",
      Color(1, 1, 1, 1), 1500,
      Color(1, 1, 1, 0), 1500,
      Color(.2, .2, .2, 0));
   DoScale("fScale",
      2, 1500,
      1, 1500);
   Do("expire", 1000)

DoUp( "vRotate", -.9, 0 );


end

